
IF NOT EXISTS(
	SELECT 
		1
	FROM 
		 sys.tables 
	WHERE 
		NAME = 'EST_PROD_TBL_DESC_PRC_FILIAL' )
BEGIN
	SET ANSI_NULLS ON

	SET QUOTED_IDENTIFIER ON

	CREATE TABLE [dbo].[EST_PROD_TBL_DESC_PRC_FILIAL](
		[CD_EMP] [int] NOT NULL,
		[CD_TBL_DESC] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[PERC_DESC] [money] NOT NULL,
		[PERC_DESC_MAX] [money] NOT NULL,
		[PERC_DESC_LIMITE] [money] NOT NULL,
		[PERC_AUMENTO] [money] NOT NULL,
	 CONSTRAINT [PK_EST_PROD_TBL_DESC_PRC_FILIAL] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_TBL_DESC] ASC,
		[CD_FILIAL] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY]


	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_PRC_FILIAL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_DESC_PRC_FILIAL_EST_PROD_TBL_DESC] FOREIGN KEY([CD_EMP], [CD_TBL_DESC])
	REFERENCES [dbo].[EST_PROD_TBL_DESC] ([CD_EMP], [CD_TBL_DESC])
	ON UPDATE CASCADE
	ON DELETE CASCADE


	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_PRC_FILIAL] CHECK CONSTRAINT [FK_EST_PROD_TBL_DESC_PRC_FILIAL_EST_PROD_TBL_DESC]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_PRC_FILIAL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_DESC_PRC_FILIAL_PRC_FILIAL] FOREIGN KEY([CD_EMP], [CD_FILIAL])
	REFERENCES [dbo].[PRC_FILIAL] ([CD_EMP], [CD_FILIAL])
	ON UPDATE CASCADE

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_PRC_FILIAL] CHECK CONSTRAINT [FK_EST_PROD_TBL_DESC_PRC_FILIAL_PRC_FILIAL]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_PRC_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_TBL_DESC_PRC_FILIAL_PERC_DESC]  DEFAULT ((0)) FOR [PERC_DESC]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_PRC_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_TBL_DESC_PRC_FILIAL_PERC_DESC_REC]  DEFAULT ((0)) FOR [PERC_DESC_MAX]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_PRC_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_TBL_DESC_PRC_FILIAL_PERC_DESC_LIMITE]  DEFAULT ((0)) FOR [PERC_DESC_LIMITE]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_PRC_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_TBL_DESC_PRC_FILIAL_PERC_AUMENTO]  DEFAULT ((0)) FOR [PERC_AUMENTO]

END

